<?php
$domain = ''; // EDIT ME (eg. 'sonarr.example.com')
$apikey = ''; // EDIT ME (found in Settings > General)

$start = date('Y-m-d', strtotime('-1 days'));
$end = date('Y-m-d', strtotime('+7 days'));

// ---

$url = sprintf(
  'https://%s/api/v3/calendar?start=%s&end=%s&includeSeries=true&includeEpisodeFile=true&includeEpisodeImages=true',
  $domain,
  $start,
  $end,
);

$curl = curl_init();
curl_setopt_array($curl, array(
  CURLOPT_URL => $url,
  CURLOPT_RETURNTRANSFER => true,
  CURLOPT_SSL_VERIFYHOST => 0,
  CURLOPT_SSL_VERIFYPEER => 0,
  CURLOPT_ENCODING => '',
  CURLOPT_MAXREDIRS => 10,
  CURLOPT_TIMEOUT => 0,
  CURLOPT_FOLLOWLOCATION => true,
  CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
  CURLOPT_HTTPHEADER => array(
    'X-Api-Key: ' . $apikey,
  )
));

$response = curl_exec($curl);
curl_close($curl);

$data = json_decode($response);

$out = [];

foreach($data as $d) {
  $out[] = array(
    'show' => $d->series->title,
    'images' => $d->series->images,
    'season' => $d->seasonNumber,
    'episode' => $d->episodeNumber,
    'title' => $d->title,
    'airdate' => $d->airDateUtc,
    'timestamp' => strtotime($d->airDateUtc) * 1000,
    'ready' => $d->hasFile,
    // 'sceneName' => @$d->episodeFile->sceneName,
    'quality' => @$d->episodeFile->quality->quality->name,
    'mediainfo' => @$d->episodeFile->mediaInfo,
  );
}

header('Content-Type: application/json');
echo json_encode($out);
