// ==UserScript==
// @name        4chan Page 10 Notifier
// @namespace   Violentmonkey Scripts
// @match       https://boards.4chan.org/*/thread/*
// @grant       none
// @version     1.0
// @author      Kody
// @icon        https://www.google.com/s2/favicons?domain=4chan.org
// @description Notify when the thread gets to page 10.
// ==/UserScript==

(function () {
  'use strict'

  const lastPage = 10

  let curPage
  let notified = false

  const pageNotify = (page) => {
    if (curPage < lastPage || notified) {
      return
    }

    // Send a browser notification
    if (window.Notification.permission === 'granted') {
      const notification = new window.Notification(
        'Last Page Reached', {
          body: `The thread has reached page ${page}.`,
          icon: 'https://www.google.com/s2/favicons?domain=4chan.org',
        }
      )
      notification.onclick = () => {
        window.focus()
        notification.close()
      }

      notified = true
    }

    curPage = page
  }

  const pageCountEl = document.getElementById('page-count')
  if (pageCountEl) {
    let pageCount = pageCountEl.innerText
    console.log('Current page:', pageCount)

    const observer = new window.MutationObserver(
      () => {
        pageCount = pageCountEl.innerText
        pageNotify(pageCount)
      }
    )
    observer.observe(
      pageCountEl,
      {
        childList: true,
        subtree: true,
      }
    )
  }
})()
