// ==UserScript==
// @name        8chan board search
// @namespace   moe.rita.8chanSearchInThreads
// @match       https://8chan.moe/*/res/*
// @match       https://8chan.se/*/res/*
// @match       https://8chan.moe/*/catalog*
// @match       https://8chan.se/*/catalog*
// @run-at      document-end
// @grant       none
// @version     1.1.0
// @author      Kody
// @description Search a string in all threads, in the current board
// ==/UserScript==

window.searchInThreads = (searchString) => {
  // Search for any post containing our `searchString` in 8chan.moe's threads from the current board.
  // First, let's grab the current board's name from the URL.
  const boardName = window.location.pathname.split('/')[1]

  // Now we'll get all the threads on the current board.
  fetch(`https://8chan.moe/${boardName}/catalog.json`)
    .then((catalogResponse) => catalogResponse.json())
    .then(async (catalogData) => {
      // Now we'll loop through each thread and check if the search string is present in any message.
      for (const thread of catalogData) {
        await fetch(`https://8chan.moe/${boardName}/res/${thread.threadId}.json`)
          .then((threadResponse) => threadResponse.json())
          .then((threadData) => {
            // And now we'll go through each post and check if we find a match
            for (const post of threadData.posts) {
              if (post.message && post.message.includes(searchString)) {
                // Let's log the post URL and the the first line
                const lines = post.message.split('\n')
                console.log(`https://8chan.moe/${boardName}/res/${thread.threadId}.html#${post.postId}`)
                console.log(`%c${lines[0]}`, 'font-style: italic;')
                if (lines.length > 1) console.log(`%c(and ${lines.length - 1} more line${lines.length === 2 ? '' : 's'})`, 'color: gray; font-style: italic;')
                console.log(' ')
              }
            }
          })
          .catch((error) => {
            console.error('Error fetching thread:', error)
          })
      }

      console.log('%cSearch completed.', 'color: green; font-weight: bold;')
    })
    .catch((error) => {
      console.error('Error fetching catalog:', error)
    })
}
